//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System.ComponentModel;
using System.Configuration;
using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;
using SysConfig = System.Configuration;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Tests
{
	[TestClass]
	public class ByteArrayConverterFixture
	{

		private const string sectionName = "byteArrayConverter";		

		[TestInitialize]
		public void TestInitialize()
		{
			SysConfig.Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			config.Sections.Remove(sectionName);
			config.Save();
		}

		[TestMethod]		
		public void SerializeAndDeserializeAByteArray()
		{
			SysConfig.Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			ConverterSection section = new ConverterSection();
			section.ByteArray = new byte[] { 1, 2, 3, 4 };
			config.Sections.Add(sectionName, section);
			config.Save();

			
			config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			section = config.Sections[sectionName] as ConverterSection;
			Assert.IsNotNull(section);
			Assert.AreEqual<byte>(section.ByteArray[0], 1);
		}

		[TestMethod]
		public void SerializeAndDeserialzieANullByteArray()
		{
			SysConfig.Configuration config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			ConverterSection section = new ConverterSection();
			section.ByteArray = null;
			config.Sections.Add(sectionName, section);
			config.Save();


			config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			section = config.Sections[sectionName] as ConverterSection;
			Assert.IsNotNull(section);
			Assert.IsNull(section.ByteArray);
		}
		
		public class ConverterSection : ConfigurationSection
		{
			private const string propertyName = "property";

			[ConfigurationProperty(propertyName)]
			[TypeConverter(typeof(ByteArrayTypeConverter))]
			public byte[] ByteArray
			{
				get { return (byte[])base[propertyName]; }
				set { base[propertyName] = value; }
			}
		}
		
	}
}
